jQuery(document).ready(function ($) {
    // Function to display admin notice dynamically
    function displayAdminNotice(message, type = 'success') {
        const notice = $(
            `<div class="notice notice-${type} is-dismissible">
                <p>${message}</p>
                <button type="button" class="notice-dismiss">
                    <span class="screen-reader-text">${tourtaskWP.messages.dismissNotice}</span>
                </button>
            </div>`
        );

        $('.wrap').prepend(notice);

        // Add dismiss functionality
        notice.find('.notice-dismiss').on('click', function () {
            notice.remove();
        });

		setTimeout(() => {
			notice.remove();
		}, 5000);
    }

    // Check if we are on the shortcode page
    if ($('#shortcode-lang').length) {
        const langSelect = $('#shortcode-lang');
        const shortcodeDisplay = $('#shortcode-display');
        const copyButton = $('#copy-shortcode');
        
        // Update the shortcode display based on selected language
        langSelect.on('change', function () {
            const selectedLang = langSelect.val();
            shortcodeDisplay.text(`[tourtask-wp page="activities" lang="${selectedLang}"]`);
        });

        // Copy shortcode to clipboard
        copyButton.on('click', function () {
            const shortcodeText = shortcodeDisplay.text();
            navigator.clipboard.writeText(shortcodeText).then(function () {
                displayAdminNotice(tourtaskWP.messages.shortcodeCopiedToClipboard);
            }, function (err) {
                displayAdminNotice(tourtaskWP.messages.copyError, 'error');
                console.error('Could not copy text: ', err);
            });
        });
    }

	// Show/hide custom header settings based on the checkbox
	$('input[name="tourtask_wp_use_custom_header"]').on('change', function () {
		if ($(this).is(':checked')) {
			$('#tourtask-wp-settings-custom-header-wrap').show();
		} else {
			$('#tourtask-wp-settings-custom-header-wrap').hide();
		}
	}).trigger('change'); // Trigger change event on page load
	
	// Show/hide custom header settings based on the checkbox
	$('input[name="tourtask_wp_use_mobile_header"]').on('change', function () {
		if ($(this).is(':checked')) {
			$('#tourtask-wp-settings-custom-mobile-header-wrap').show();
		} else {
			$('#tourtask-wp-settings-custom-mobile-header-wrap').hide();
		}
	}).trigger('change'); // Trigger change event on page load

	/////Update the example code based on the header name and type
	function updateExample(isMain) {
		const headerName = $(`#${isMain ? 'mobile_' : ''}header_name`).val();
		const headerType = $(`input[name="tourtask_wp_${isMain ? 'mobile_' : ''}header_type"]:checked`).val();
		let exampleCode = '';

		let headerNameString = headerName ? headerName : 'example';
		let headerTypeString = headerType;

		if (headerType === 'id') {
			exampleCode = `<div id="${headerName}">Header contents</div>`;
		} else if (headerType === 'class') {
			exampleCode = `<div class="${headerName}">Header contents</div>`;
		}

		$(`#${isMain ? 'mobile_' : ''}header_name_string`).text(headerNameString);
		$(`#${isMain ? 'mobile_' : ''}header_type_string`).text(headerTypeString);
	}

	$('#header_name').on('input', updateExample);
	$('input[name="tourtask_wp_header_type"]').on('change', updateExample);
	

	$('#tourtask_wp_mobile_header_name').on('input', updateExample);
	$('input[name="tourtask_wp_mobile_header_type"]').on('change', updateExample);

	// Initial update to set the example based on the current values
	updateExample();
	updateExample('mobile');

	/////Handle form submission via AJAX
	$('#settings-form').on('submit', function (e) {
		e.preventDefault();

		var $form = $(this);
		var $submitButton = $form.find('input[type="submit"]');
        var $inputs = $form.find('input[type="text"], input[type="checkbox"], select, textarea, button');
		
		$submitButton.addClass('loading');
        $inputs.prop('disabled', true);

		var tourtask_wp_business_abbreviation = $('#tourtask_wp_business_abbreviation').val();
		var tourtask_wp_business_token = $('#tourtask_wp_business_token').val();
		var tourtask_wp_force_full_width = $('#tourtask_wp_force_full_width').is(':checked') ? '1' : '0';
		var tourtask_wp_use_custom_header = $('#tourtask_wp_use_custom_header').is(':checked') ? '1' : '0';
		var tourtask_wp_header_name = $('#tourtask_wp_header_name').val();
		var tourtask_wp_header_type = $('input[name="tourtask_wp_header_type"]:checked').val();
		var tourtask_wp_header_is_sticky = $('#tourtask_wp_header_is_sticky').is(':checked') ? '1' : '0';
		var tourtask_wp_use_mobile_header = $('#tourtask_wp_use_mobile_header').is(':checked') ? '1' : '0';
		var tourtask_wp_mobile_header_name = $('#tourtask_wp_mobile_header_name').val();
		var tourtask_wp_mobile_header_type = $('input[name="tourtask_wp_mobile_header_type"]:checked').val();
		var tourtask_wp_mobile_header_is_sticky = $('#tourtask_wp_mobile_header_is_sticky').is(':checked') ? '1' : '0';
		var tourtask_wp_mobile_header_until_width = $('#tourtask_wp_mobile_header_until_width').val();
		var tourtask_wp_options_group_nonce = $('#tourtask_wp_options_group_nonce').val();

		var formData = {
			tourtask_wp_business_abbreviation,
			tourtask_wp_business_token,
			tourtask_wp_force_full_width,
			tourtask_wp_use_custom_header,
			tourtask_wp_header_name,
			tourtask_wp_header_type,
			tourtask_wp_header_is_sticky,
			tourtask_wp_use_mobile_header,
			tourtask_wp_mobile_header_name,
			tourtask_wp_mobile_header_type,
			tourtask_wp_mobile_header_is_sticky,
			tourtask_wp_mobile_header_until_width,
			tourtask_wp_options_group_nonce
		};

		// Send AJAX request
		$.ajax({
			url: tourtaskWP.ajax_url,
			type: 'POST',
			data: {
				action: 'tourtask_wp_save_settings',
				data: formData
			},
			success: function (response) {
				// Handle success
                displayAdminNotice(tourtaskWP.messages.settingsSaved);
			},
			error: function (response) {
				// Handle error
                displayAdminNotice(tourtaskWP.messages.settingsSaveError, 'error');
			},
			complete: function () {
				$submitButton.removeClass('loading');
				$inputs.prop('disabled', false);
			}
		});
	});

	// Handle Thickbox form submission
	$('#tourtask-wp-issue-form').on('submit', function (e) {
		e.preventDefault();

		var $form = $(this);
		var $submitButton = $form.find('input[type="submit"]');
        var $inputs = $form.find('input[type="text"], input[type="email"], select, textarea, button');

		$submitButton.addClass('loading');
        $inputs.prop('disabled', true);

		var websiteUrl = $('#site-url').val();
		var themeName = $('#wp-theme-name').val();
		var themeCode = $('#wp-theme-code').val();
		var themeVersion = $('#wp-theme-version').val();
		var userName = $('#user-name').val();
		var userEmail = $('#user-email').val();
		var userPhone = $('#user-phone').val();
		var userLangCode = $('#user-lang-code').val();
		var message = $('#user-message').val();

		var bizSlug = $('#tt-business-abbreviation').val();
		var bizToken = $('#tt-business-token').val();

		const requestMode = 'sendEmail';
		const sendEmailMode = 'tourtaskWpThemeIssues';

		$.ajax({
			url: 'https://api.tourtask.com/public/v1/' + requestMode,
			type: 'POST',
			contentType: 'application/json',
			data: JSON.stringify({
				bizSlug: bizSlug,
				bizToken: bizToken,
				params: {
					userLangCode: userLangCode,
					mode: sendEmailMode,
					formData: {
						websiteUrl: websiteUrl,
						cms: 'wordpress',
						themeName: themeName,
						themeCode: themeCode,
						themeVersion: themeVersion,
						bizAbbreviation: bizSlug,
						bizToken: bizToken,
						userName: userName,
						userEmail: userEmail,
						userPhone: userPhone,
						message: message
					}
				}
			}),
			success: function (response) {
				if (response[requestMode]) { //Success
					displayAdminNotice(tourtaskWP.messages.messageSentRespondSoon);
					tb_remove(); // Close Thickbox
				} else if (response.error && response.error.message) {
					displayAdminNotice(response.error.message, 'error');
				} else { //Unknown error
					displayAdminNotice(tourtaskWP.messages.settingsSaveError, 'error');
					console.log(response);
				}
				
			},
			error: function (response) {
                displayAdminNotice(tourtaskWP.messages.settingsSaveError, 'error');
				console.log(response);
			},
            complete: function () {
				$submitButton.removeClass('loading');
				$inputs.prop('disabled', false);
            }
		});
	});
});
