<?php
function tourtask_wp_settings() {
	$currentTheme = wp_get_theme();
	$themeName = $currentTheme->get('Name');
	$themeVersion = $currentTheme->get('Version');
	$themeCode = $currentTheme->get_stylesheet();

	$currentUser = wp_get_current_user();
	$userName = $currentUser->display_name;
	$userEmail = $currentUser->user_email;
    
    $siteUrl = home_url();

	?>
	<div class="wrap">
		<h1><?php esc_html_e('TourTask WP Settings', 'tourtask-wp'); ?></h1>
		<form id="settings-form" method="post" action="options.php">
			<?php settings_fields('tourtask_wp_options_group'); ?>
			<?php wp_nonce_field('tourtask_wp_options_group', 'tourtask_wp_options_group_nonce'); ?>
			<?php do_settings_sections('tourtask_wp_options_group'); ?>
			<table class="form-table">
				<tr valign="top">
					<th scope="row"><?php esc_html_e('Business abbreviation', 'tourtask-wp'); ?></th>
					<td><input type="text" id="tourtask_wp_business_abbreviation" name="tourtask_wp_business_abbreviation" value="<?php echo esc_attr(get_option('tourtask_wp_business_abbreviation')); ?>" maxlength="60" required /></td>
				</tr>
				<tr valign="top">
					<th scope="row"><?php esc_html_e('Business token', 'tourtask-wp'); ?></th>
					<td><input type="text" id="tourtask_wp_business_token" name="tourtask_wp_business_token" value="<?php echo esc_attr(get_option('tourtask_wp_business_token')); ?>" maxlength="8" required /></td>
				</tr>
				<tr valign="top">
					<th scope="row">
						<?php esc_html_e('Force full width and remove space', 'tourtask-wp'); ?>
					</th>
					<td>
						<label>
							<input type="checkbox" id="tourtask_wp_force_full_width" name="tourtask_wp_force_full_width" value="1" <?php checked(1, get_option('tourtask_wp_force_full_width', '1'), true); ?> />
							<?php esc_html_e('Make the booking system fill out the full width of your activities page and remove any excess space', 'tourtask-wp'); ?>
						</label>
						<div style="margin-top: 10px;">
							<a href="#TB_inline?width=600&height=400&inlineId=contact-us-modal" class="thickbox" title="<?php esc_html_e('Help Us Improve TourTask WP', 'tourtask-wp'); ?>"><?php esc_html_e('Doesn\'t work? Let us know', 'tourtask-wp'); ?></a>
						</div>
					</td>
				</tr>
			</table>

			<h2><?php esc_html_e('Advanced settings', 'tourtask-wp'); ?></h2>
			<table class="form-table">
				<tr>
					<th scope="row"><?php esc_html_e('Use custom header', 'tourtask-wp'); ?></th>
					<td>
						<label>
							<input type="checkbox" id="tourtask_wp_use_custom_header" name="tourtask_wp_use_custom_header" value="1" <?php checked(1, get_option('tourtask_wp_use_custom_header'), true); ?> />
							<?php esc_html_e('If the cart bar on your activities page doesn\'t appear correctly beneath the website header, you may specify the header HTML element manually', 'tourtask-wp'); ?>
						</label>
					</td>
				</tr>
			</table>
			<div id="tourtask-wp-settings-custom-header-wrap" class="card">
				<h3><?php esc_html_e('Custom header element identification', 'tourtask-wp'); ?></h3>
				<table class="form-table">
					<tr>
						<th scope="row"><?php esc_html_e('Name', 'tourtask-wp'); ?></th>
						<td><input type="text" id="tourtask_wp_header_name" name="tourtask_wp_header_name" value="<?php echo esc_attr(get_option('tourtask_wp_header_name')); ?>" maxlength="200" /></td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e('Type', 'tourtask-wp'); ?></th>
						<td style="padding-bottom: 0;">
							<div style="margin-bottom: 10px;">
								<label>
									<input type="radio" id="tourtask_wp_header_type" name="tourtask_wp_header_type" value="id" <?php checked('id', get_option('tourtask_wp_header_type', 'id'), true); ?> />
									<?php esc_html_e('ID', 'tourtask-wp'); ?>
								</label>
							</div>
							<label>
								<input type="radio" id="tourtask_wp_header_type" name="tourtask_wp_header_type" value="class" <?php checked('class', get_option('tourtask_wp_header_type'), true); ?> />
								<?php esc_html_e('Class', 'tourtask-wp'); ?>
							</label>
						</td>
					</tr>
					<tr>
						<td colspan="2" style="padding-top: 0; padding-left: 0;">
							<div style="margin-bottom: 5px;"><?php esc_html_e('Example', 'tourtask-wp'); ?>:</div>
							<code><?php esc_html_e('<div '); ?><span id="header_type_string"></span>="<span id="header_name_string"></span>"><?php esc_html_e('Header contents', 'tourtask-wp'); ?><?php esc_html_e('</div>'); ?></code>
						</td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e('Is sticky', 'tourtask-wp'); ?></th>
						<td><input type="checkbox" id="tourtask_wp_header_is_sticky" name="tourtask_wp_header_is_sticky" value="1" <?php checked(1, get_option('tourtask_wp_header_is_sticky'), true); ?> /></td>
					</tr>
					<tr>
						<th scope="row"><?php esc_html_e('Use mobile header', 'tourtask-wp'); ?></th>
						<td>
							<input type="checkbox" id="tourtask_wp_use_mobile_header" name="tourtask_wp_use_mobile_header" value="1" <?php checked(1, get_option('tourtask_wp_use_mobile_header'), true); ?> />
							<?php esc_html_e('Theme uses a different header element on smaller devices', 'tourtask-wp'); ?>
						</td>
					</tr>
				</table>

				<div id="tourtask-wp-settings-custom-mobile-header-wrap" class="card" style="margin-bottom: 20px;">
					<h3><?php esc_html_e('Mobile header', 'tourtask-wp'); ?></h3>
					<table class="form-table">
						<tr>
							<th scope="row"><?php esc_html_e('Name', 'tourtask-wp'); ?></th>
							<td><input type="text" id="tourtask_wp_mobile_header_name" name="tourtask_wp_mobile_header_name" value="<?php echo esc_attr(get_option('tourtask_wp_mobile_header_name')); ?>" maxlength="200" /></td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e('Type', 'tourtask-wp'); ?></th>
							<td style="padding-bottom: 0;">
								<div style="margin-bottom: 10px;">
									<label>
										<input type="radio" id="tourtask_wp_mobile_header_type" name="tourtask_wp_mobile_header_type" value="id" <?php checked('id', get_option('tourtask_wp_mobile_header_type', 'id'), true); ?> />
										<?php esc_html_e('ID', 'tourtask-wp'); ?>
									</label>
								</div>
								<label>
									<input type="radio" id="tourtask_wp_mobile_header_type" name="tourtask_wp_mobile_header_type" value="class" <?php checked('class', get_option('tourtask_wp_mobile_header_type'), true); ?> />
									<?php esc_html_e('Class', 'tourtask-wp'); ?>
								</label>
							</td>
						</tr>
						<tr>
							<td colspan="2" style="padding-top: 0; padding-left: 0;">
								<div style="margin-bottom: 5px;"><?php esc_html_e('Example', 'tourtask-wp'); ?>:</div>
								<code><?php esc_html_e('<div '); ?><span id="mobile_header_type_string"></span>="<span id="mobile_header_name_string"></span>"><?php esc_html_e('Header contents', 'tourtask-wp'); ?><?php esc_html_e('</div>'); ?></code>
							</td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e('Is sticky', 'tourtask-wp'); ?></th>
							<td><input type="checkbox" id="tourtask_wp_mobile_header_is_sticky" name="tourtask_wp_mobile_header_is_sticky" value="1" <?php checked(1, get_option('tourtask_wp_mobile_header_is_sticky'), true); ?> /></td>
						</tr>
						<tr>
							<th scope="row"><?php esc_html_e('Until width (px)', 'tourtask-wp'); ?></th>
							<td><input type="number" id="tourtask_wp_mobile_header_until_width" name="tourtask_wp_mobile_header_until_width" value="<?php echo esc_attr(get_option('tourtask_wp_mobile_header_until_width')); ?>" min="0" max="3000" />
							<div style="margin-top: 10px;"><?php esc_html_e('Header will be used from this width and below', 'tourtask-wp'); ?></div></td>
						</tr>
					</table>
				</div>
			</div>

			<!-- New fieldset -->
			<fieldset style="border: 1px solid #ccc; padding: 20px; margin-top: 20px; background-color: #f9f9f9;">
				<legend style="font-weight: bold;"><?php esc_html_e('Need Help?', 'tourtask-wp'); ?></legend>
				<p style="margin-top: 0;"><?php esc_html_e('If TourTask WP doesn\'t look good when integrated to your website, or if you have problems with the cart bar, contact us so we can help you.', 'tourtask-wp'); ?></p>
				<a href="#TB_inline?width=600&height=400&inlineId=contact-us-modal" class="thickbox button" title="<?php esc_html_e('Help Us Improve TourTask WP', 'tourtask-wp'); ?>">
					<?php esc_html_e('Contact Us', 'tourtask-wp'); ?>
				</a>
			</fieldset>
			<?php submit_button(); ?>
		</form>
	</div>

	<!-- Thickbox Modal Content -->
	<div id="contact-us-modal" style="display:none;">
		<p><?php esc_html_e('We strive to ensure TourTask WP works with every WordPress theme. If it doesn\'t work for your theme, please contact us, so we can update TourTask WP and make it work for you as well.', 'tourtask-wp'); ?></p>
		
		<form id="tourtask-wp-issue-form">
			<table class="form-table">
				<tr>
					<th scope="row" colspan="2"><h3><?php esc_html_e('Website', 'tourtask-wp'); ?></h3></th>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('URL', 'tourtask-wp'); ?></th>
					<td><?php echo esc_html($siteUrl); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Theme Name', 'tourtask-wp'); ?></th>
					<td><?php echo esc_html($themeName); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Theme Code', 'tourtask-wp'); ?></th>
					<td><?php echo esc_html($themeCode); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Theme Version', 'tourtask-wp'); ?></th>
					<td><?php echo esc_html($themeVersion); ?></td>
				</tr>
				<tr>
					<th scope="row" colspan="2"><h3><?php esc_html_e('TourTask data', 'tourtask-wp'); ?></h3></th>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Business abbreviation', 'tourtask-wp'); ?></th>
					<td><?php echo esc_attr(get_option('tourtask_wp_business_abbreviation')); ?></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Business token', 'tourtask-wp'); ?></th>
					<td><?php echo esc_attr(get_option('tourtask_wp_business_token')); ?></td>
				</tr>
				<tr>
					<th scope="row" colspan="2"><h3><?php esc_html_e('Contact information', 'tourtask-wp'); ?></h3></th>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Name', 'tourtask-wp'); ?></th>
					<td><input type="text" id="user-name" name="user_name" value="<?php echo esc_attr($userName); ?>"></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Email', 'tourtask-wp'); ?></th>
					<td><input type="email" id="user-email" name="user_email" value="<?php echo esc_attr($userEmail); ?>"></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Phone', 'tourtask-wp'); ?></th>
					<td><input type="text" id="user-phone" name="user_phone" value=""></td>
				</tr>
				<tr>
					<th scope="row"><?php esc_html_e('Message', 'tourtask-wp'); ?></th>
					<td><textarea id="user-message" name="user_message" rows="4" cols="50" style="min-height: 100px;"></textarea></td>
				</tr>
			</table>

			<input type="hidden" id="site-url" value="<?php echo esc_url($siteUrl); ?>">
			<input type="hidden" id="wp-theme-name" value="<?php echo esc_html($themeName); ?>">
			<input type="hidden" id="wp-theme-code" value="<?php echo esc_html($themeCode); ?>">
			<input type="hidden" id="wp-theme-version" value="<?php echo esc_html($themeVersion); ?>">
			<input type="hidden" id="tt-business-abbreviation" value="<?php echo esc_attr(get_option('tourtask_wp_business_abbreviation')); ?>">
			<input type="hidden" id="tt-business-token" value="<?php echo esc_attr(get_option('tourtask_wp_business_token')); ?>">
			<input type="hidden" id="user-lang-code" value="<?php echo esc_attr(substr(get_user_locale(), 0, 2)); ?>; ?>">
			
			<?php submit_button(__('Send', 'tourtask-wp'), 'primary', 'send-info'); ?>
		</form>
	</div>
	<?php
}

function tourtask_wp_enqueue_thickbox() {
    $screen = get_current_screen();
    if ($screen->id === 'toplevel_page_tourtask-wp') {
        add_thickbox();
        wp_enqueue_style('thickbox');
    }
}
add_action('admin_enqueue_scripts', 'tourtask_wp_enqueue_thickbox');
?>
